-- Microsoft SQL Server DDL
-- create constraints and indices script

-- start
use pcweek
go
select "starting full indexing run", getdate()
go

-- uniques
select "creating uniques indices", getdate()
go

alter table uniques add constraint uniques_key_PK_IDX primary key clustered (u_key) with fillfactor=90
go

alter table uniques add constraint uniques_code_CK_IDX unique nonclustered (u_code) with fillfactor=90
go

alter table uniques add constraint uniques_signed_CK_IDX unique nonclustered (u_signed) with fillfactor=90
go

--create nonclustered index uniques_float_double_IDX
--on uniques (u_float, u_double) with fillfactor=90
--go

select "finished creating uniques indices", getdate()
go

-- hundred
select "creating hundred indices", getdate()
go

alter table hundred add constraint hundred_key_PK_IDX primary key clustered (h_key) with fillfactor=90
go

alter table hundred add constraint hundred_code_CK_IDX unique nonclustered (h_code) with fillfactor=90
go

create nonclustered index hundred_int_IDX
on hundred (h_int) with fillfactor=90
go

create nonclustered index hundred_signed_IDX
on hundred (h_signed) with fillfactor=90
go

create nonclustered index hundred_date_IDX
on hundred (h_date) with fillfactor=90
go

create nonclustered index hundred_name_IDX
on hundred (h_name) with fillfactor=90
go

--create nonclustered index hundred_signed_decim_name_IDX
--on hundred (h_signed, h_decim, h_name) with fillfactor=90
--go

select "finished creating hundred indices", getdate()
go

-- tenpct
select "creating tenpct indices", getdate()
go

alter table tenpct add constraint tenpct_key_code_PK_IDX primary key clustered (t_key, t_code) with fillfactor=90
go

alter table tenpct add constraint tenpct_code_CK_IDX unique nonclustered (t_code) with fillfactor=90
go

--create nonclustered index tenpct_int_signed_decim_IDX
--on tenpct (t_int, t_signed, t_decim) with fillfactor=90
--go

create nonclustered index tenpct_int_IDX
on tenpct (t_int) with fillfactor=90
go

create nonclustered index tenpct_signed_IDX
on tenpct (t_signed) with fillfactor=90
go

create nonclustered index tenpct_float_IDX
on tenpct (t_float) with fillfactor=90
go

create nonclustered index tenpct_double_IDX
on tenpct (t_double) with fillfactor=90
go

create nonclustered index tenpct_decim_IDX
on tenpct (t_decim) with fillfactor=90
go

create nonclustered index tenpct_date_IDX
on tenpct (t_date) with fillfactor=90
go

create nonclustered index tenpct_name_IDX
on tenpct (t_name) with fillfactor=90
go

--create nonclustered index tenpct_name_int_IDX
--on tenpct (t_name, t_int) with fillfactor=90
--go

select "finished creating tenpct indices", getdate()
go

-- updates
select "creating updates indices", getdate()
go

alter table updates add constraint updates_key_PK_IDX primary key clustered (p_key) with fillfactor=90
go

-- dropped this index because oltp_write_insert_2 needs a non-unique index
create nonclustered index updates_code_IDX on updates (p_code) with fillfactor=90
go

create nonclustered index updates_int_IDX
on updates (p_int) with fillfactor=90
go

create nonclustered index updates_signed_IDX
on updates (p_signed) with fillfactor=90
go

--create nonclustered index updates_float_IDX
--on updates (p_float) with fillfactor=90
--go

--create nonclustered index updates_double_IDX
--on updates (p_double) with fillfactor=90
--go

create nonclustered index updates_decim_IDX
on updates (p_decim) with fillfactor=90
go

create nonclustered index updates_date_IDX
on updates (p_date) with fillfactor=90
go

alter table updates add constraint updates_int_FK foreign key (p_int) references hundred (h_key)
go

-- dropped, made oltp_write_insert_2 fail too often
--alter table updates add constraint updates_signed_FK foreign key (p_signed) references uniques (u_signed)
--go

select "finished creating updates indices", getdate()
go

-------------------------

-- tenthou
select "creating tenthou indices", getdate()
go

-- ERROR: doesn't work (small dataset has duplicate t_code entry)
alter table tenthou add constraint tenthou_key_code_PK_IDX primary key clustered (t_key, t_code) with fillfactor=90
go

-- ERROR: doesn't work (small dataset has duplicate t_code entry)
--alter table tenthou add constraint tenthou_code_CK_IDX unique nonclustered (t_code) with fillfactor=90
--go

--create nonclustered index tenthou_int_signed_decim_IDX
--on tenthou (t_int, t_signed, t_decim) with fillfactor=90
--go

create nonclustered index tenthou_signed_IDX
on tenthou (t_signed) with fillfactor=90
go

--create nonclustered index tenthou_float_IDX
--on tenthou (t_float) with fillfactor=90
--go

--create nonclustered index tenthou_double_IDX
--on tenthou (t_double) with fillfactor=90
--go

create nonclustered index tenthou_decim_IDX
on tenthou (t_decim) with fillfactor=90
go

create nonclustered index tenthou_name_IDX
on tenthou (t_name) with fillfactor=90
go

--create nonclustered index tenthou_name_int_IDX
--on tenthou (t_name, t_int) with fillfactor=90
--go

select "finished creating tenthou indices", getdate()
go

-- hunthou
select "creating hunthou indices", getdate()
go

--alter table hunthou add constraint hunthou_key_PK_IDX primary key clustered (h_key) with fillfactor=90
--go

--alter table hunthou add constraint hunthou_code_CK_IDX unique nonclustered (h_code) with fillfactor=90
--go

--create nonclustered index hunthou_signed_decim_name_IDX
--on hunthou (h_signed, h_decim, h_name) with fillfactor=90
--go

create nonclustered index hunthou_signed_IDX
on hunthou (h_signed) with fillfactor=90
go

select "finished creating hunthou indices", getdate()
go

-- twomill
select "creating twomill indices", getdate()
go

--alter table twomill add constraint twomill_key_PK_IDX primary key clustered (p_key) with fillfactor=90
--go

alter table twomill add constraint twomill_code_PK_IDX unique nonclustered (p_key) with fillfactor=90
go

alter table twomill add constraint twomill_code_CK_IDX unique nonclustered (p_code) with fillfactor=90
go

--create nonclustered index twomill_int_IDX
--on twomill (p_int) with fillfactor=90
--go

--create nonclustered index twomill_float_IDX
--on twomill (p_float) with fillfactor=90
--go

--create nonclustered index twomill_double_IDX
--on twomill (p_double) with fillfactor=90
--go

--create nonclustered index twomill_decim_IDX
--on twomill (p_decim) with fillfactor=90
--go

create nonclustered index twomill_datet_IDX
on twomill (p_date) with fillfactor=90
go

-- ERROR: doesn't match up with data generator data
--alter table twomill add constraint twomill_signed_FK foreign key (p_signed) references uniques (u_signed)
--go

select "creating twomill indices", getdate()
go

-- threemill
select "creating threemill indices", getdate()
go

--alter table threemill add constraint threemill_key_code_PK_IDX primary key clustered (t_key, t_code) with fillfactor=90
--go

--alter table threemill add constraint threemill_code_CK_IDX unique nonclustered (t_code) with fillfactor=90
--go

--create nonclustered index threemill_int_signed_decim_IDX
--on threemill (t_int, t_signed, t_decim) with fillfactor=90
--go

create nonclustered index threemill_signed_IDX
on threemill (t_signed) with fillfactor=90
go

--create nonclustered index threemill_float_IDX
--on threemill (t_float) with fillfactor=90
--go

--create nonclustered index threemill_double_IDX
--on threemill (t_double) with fillfactor=90
--go

--create nonclustered index threemill_decim_IDX
--on threemill (t_decim) with fillfactor=90
--go

--create nonclustered index threemill_name_IDX
--on threemill (t_name) with fillfactor=90
--go

--create nonclustered index threemill_name_int_IDX
--on threemill (t_name, t_int) with fillfactor=90
--go

select "finished creating threemill indices", getdate()
go

-- fourmill
select "creating fourmill indices", getdate()
go

--alter table fourmill add constraint fourmill_key_code_PK_IDX primary key clustered (t_key, t_code) with fillfactor=90
--go

--alter table fourmill add constraint fourmill_code_CK_IDX unique nonclustered (t_code) with fillfactor=90
--go

--create nonclustered index fourmill_int_signed_decim_IDX
--on fourmill (t_int, t_signed, t_decim) with fillfactor=90
--go

--create nonclustered index fourmill_signed_IDX
--on fourmill (t_signed) with fillfactor=90
--go

--create nonclustered index fourmill_float_IDX
--on fourmill (t_float) with fillfactor=90
--go

--create nonclustered index fourmill_double_IDX
--on fourmill (t_double) with fillfactor=90
--go

--create nonclustered index fourmill_decim_IDX
--on fourmill (t_decim) with fillfactor=90
--go

--create nonclustered index fourmill_name_IDX
--on fourmill (t_name) with fillfactor=90
--go

--create nonclustered index fourmill_name_int_IDX
--on fourmill (t_name, t_int) with fillfactor=90
--go

--select "finished creating fourmill indices", getdate()
go

-- fivemill
select "creating fivemill indices", getdate()
go

--alter table fivemill add constraint fivemill_key_PK_IDX primary key clustered (h_key) with fillfactor=90
--go

alter table fivemill add constraint fivemill_key_PK_IDX unique nonclustered (h_key) with fillfactor=90
go

alter table fivemill add constraint fivemill_code_CK_IDX unique nonclustered (h_code) with fillfactor=90
go

--create nonclustered index fivemill_signed_decim_name_IDX
--on fivemill (h_signed, h_decim, h_name) with fillfactor=90
--go

select "finishing creating fivemill indices", getdate()
go

-- sevmill
select "creating sevmill indices", getdate()
go

--alter table sevmill add constraint sevmill_key_PK_IDX primary key clustered (u_key) with fillfactor=90
--go

alter table sevmill add constraint sevmill_key_PK_IDX unique nonclustered (u_key) with fillfactor=90
go

--alter table sevmill add constraint sevmill_code_CK_IDX unique nonclustered (u_code) with fillfactor=90
--go

--create nonclustered index sevmill_float_double_IDX
--on sevmill (u_float, u_double) with fillfactor=90
--go

select "finished creating sevmill indices", getdate()
go

-- fourtymill
--select "creating fourtymill indices", getdate()

--alter table fourtymill add constraint fourtymill_key_PK_IDX primary key clustered (u_key) with fillfactor=90
--go

--alter table fourtymill add constraint fourtymill_code_CK_IDX unique nonclustered (u_code) with fillfactor=90
--go

--create nonclustered index fourtymill_float_double_IDX
--on fourtymill (u_float, u_double) with fillfactor=90
--go

-- upd_history
select "creating upd_history indices", getdate()
go

alter table upd_history add constraint upd_history_key_PK_IDX primary key clustered (x_key) with fillfactor=90
go

select "finished creating upd_history indices", getdate()
go

-- end
select "finished full indexing run", getdate()
go
checkpoint
go
